package gov.va.med.mhv.journal.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "ACTIVITY_JOURNAL_DETAIL")
public class ActivityDetail implements Serializable {

	public Long getActivityJournalId() {
		return activityJournalId;
	}

	public void setActivityJournalId(Long activityJournalId) {
		this.activityJournalId = activityJournalId;
	}

	private static final long serialVersionUID = 4538674933294206670L;

	@Id
	@Column(name = "ACTIVITY_DETAIL_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long activityDetailId;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "DESCRIPTION")
	private String description;

	@Column(name = "INTENSITY")
	private String intensity;


	@Column(name = "TIME_OF_DAY")
	private String timeOfDay;
	

	@Column(name = "ACTIVITY_TYPE")
	private String activityType;
	

	@Column(name = "MEASURE")
	private String measure;
	
	@Column(name = "SET_COUNT")
	private BigDecimal setCount;
	

	@Column(name = "REP_COUNT")
	private BigDecimal repCount;

	@Column(name = "DISTANCE_DURATION")
	private BigDecimal distanceDuration;

	@Column(name = "ACTIVITY_ID_SEQ", insertable = false, updatable = false)
	private Long activityJournalId;
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "ACTIVITY_ID_SEQ")
	private ActivityJournal activityJournal;

	public Long getActivityDetailId() {
		return activityDetailId;
	}

	public void setActivityDetailId(Long activityDetailId) {
		this.activityDetailId = activityDetailId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getIntensity() {
		return intensity;
	}

	public void setIntensity(String intensity) {
		this.intensity = intensity;
	}

	public String getTimeOfDay() {
		return timeOfDay;
	}

	public void setTimeOfDay(String timeOfDay) {
		this.timeOfDay = timeOfDay;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public String getMeasure() {
		return measure;
	}

	public void setMeasure(String measure) {
		this.measure = measure;
	}

	public BigDecimal getSetCount() {
		return setCount;
	}

	public void setSetCount(BigDecimal setCount) {
		this.setCount = setCount;
	}

	public BigDecimal getRepCount() {
		return repCount;
	}

	public void setRepCount(BigDecimal repCount) {
		this.repCount = repCount;
	}

	public BigDecimal getDistanceDuration() {
		return distanceDuration;
	}

	public void setDistanceDuration(BigDecimal distanceDuration) {
		this.distanceDuration = distanceDuration;
	}


	public ActivityJournal getActivityJournal() {
		return activityJournal;
	}

	public void setActivityJournal(ActivityJournal activityJournal) {
		this.activityJournal = activityJournal;
	}

	
}
